class FriendshipController < ApplicationController
  include ProfileHelper
  before_filter :protect, :setup_friends

  # Wyślij propozycję zawarcia znajomości.
  def create
    Friendship.request(@user, @friend)
    UserMailer.deliver_friend_request(
        :user => @user,
        :friend => @friend,
        :user_url => profile_for(@user),
        :accept_url => url_for(:action => "accept", :id => @user.screen_name),
        :decline_url => url_for(:action => "decline", :id => @user.screen_name)
    )
    flash[:notice] = "Propozycja została przesłana."
    redirect_to profile_for(@friend)
  end
  
  def accept
    if @user.requested_friends.include?(@friend)
      Friendship.accept(@user, @friend)
      flash[:notice] = "Znajomość z #{@friend.screen_name} zaakceptowana!"
    else    
      flash[:notice] = "Nie było propozycji znajomości od #{@friend.screen_name}."
    end
    redirect_to hub_url
  end

  def decline
    if @user.requested_friends.include?(@friend)
      Friendship.breakup(@user, @friend)
      flash[:notice] = "Odmówiono znajomości z #{@friend.screen_name}."
    else
      flash[:notice] = "Nie było propozycji znajomości od #{@friend.screen_name}."
    end
    redirect_to hub_url
  end

  def cancel
    if @user.pending_friends.include?(@friend)
      Friendship.breakup(@user, @friend)
      flash[:notice] = "Propozycja zawarcia znajomości została anulowana."
    else
      flash[:notice] = "Nie było propozycji znajomości od #{@friend.screen_name}"
    end
    redirect_to hub_url
  end

  def delete
    if @user.friends.include?(@friend)
      Friendship.breakup(@user, @friend)
      flash[:notice] = "Znajomość z #{@friend.screen_name} została usunięta!"
    else
    flash[:notice] = "Nie byłeś znajomym użytkownika #{@friend.screen_name}"
    end
    redirect_to hub_url
  end

private
  def setup_friends
    @user = User.find(session[:user_id])
    @friend = User.find_by_screen_name(params[:id])
  end
end

