class FaqController < ApplicationController
  before_filter :protect

  def index
    redirect_to hub_url
  end

  # Edycja FAQ użytkownika
  def edit
    @title = "Edycja FAQ"
    @user = User.find(session[:user_id])
    @user.faq ||= Faq.new
    @faq = @user.faq
    if param_posted?(:faq)
      if @user.faq.update_attributes(params[:faq])
        flash[:notice] = "FAQ został zapisany"
        redirect_to hub_url
      end
    end
  end

end
