require File.dirname(__FILE__) + '/../test_helper'
require 'friendship_controller'

# Re-raise errors caught by the controller.
class FriendshipController; def rescue_action(e) raise e end; end

class FriendshipControllerTest < Test::Unit::TestCase
  include ProfileHelper
  fixtures :users, :specs

  def setup
    @controller = FriendshipController.new
    @request = ActionController::TestRequest.new
    @response = ActionController::TestResponse.new
    @user = users(:valid_user)
    @friend = users(:friend)
    # Dopilnuj, aby wiadomości nie były faktycznie wysyłane!
    ActionMailer::Base.delivery_method = :test
  end

  def test_create
    # Zaloguj użytkownika i prześlij propozycję.
    authorize @user
    get :create, :id => @friend.screen_name
    assert_response :redirect
    assert_redirected_to profile_for(@friend)
    assert_equal "Propozycja została przesłana.", flash[:notice]
    # Zaloguj znajomego i zaakceptuj propozycję.
    authorize @friend
    get :accept, :id => @user.screen_name
    assert_redirected_to hub_url
    assert_equal "Znajomość z #{@user.screen_name} zaakceptowana!",
                 flash[:notice]
  end
end
