class UserMailer < ActionMailer::Base
  
  def reminder(user)
    @subject            = 'Twoje dane logowania do RailsSpace.com'
    @body               = {}
    # Dajemy treści dostęp do informacji o użytkowniku.
    @body["user"] = user
    @recipients = user.email
    @from = 'RailsSpace <do-not-reply@railsspace.com>'
  end
  
  def message(mail)
    subject      mail[:message].subject
    from         'RailsSpace <do-not-reply@railsspace.com>'
    recipients   mail[:recipient].email
    body         mail
  end

  def friend_request(mail)
    subject      'Nowa propozycja znajomości w RailsSpace'
    from         'RailsSpace <do-not-reply@railsspace.com>'
    recipients   mail[:friend].email
    body         mail
  end
end
