class Faq < ActiveRecord::Base
  belongs_to :user
  acts_as_ferret
  
  QUESTIONS = %w(bio skillz schools companies
                 music movies television books magazines)
  # Stała dla wszystkiego poza życiorysem
  FAVORITES = QUESTIONS - %w(bio)
  TEXT_ROWS = 10
  TEXT_COLS = 40
  
  HUMANIZED_ATTRIBUTES = {
  :bio => "Życiorys",
  :skillz => "Umiejętności",
  :schools => "Wykształcenie",
  :companies => "Miejsca pracy",
  :music => "Muzyka",
  :movies => "Filmy",
  :television => "Programy telewizyjne",
  :books => "Książki",
  :magazines => "Czasopisma"
  }
  
  def self.human_attribute_name(attr)
    HUMANIZED_ATTRIBUTES[attr.to_sym] || super
  end

  validates_length_of QUESTIONS,
                      :maximum => DB_TEXT_MAX_LENGTH
  def initialize
    super
    QUESTIONS.each do |question|
      self[question] = ""
    end
  end
end
