class Avatar < ActiveRecord::Base
  
  # Rozmiary obrazów
  IMG_SIZE = '"240x300>"'
  THUMB_SIZE = '"50x64"'

  # Katalogi obrazów
  if ENV["RAILS_ENV"] == "test"
    URL_STUB = DIRECTORY = "tmp"
  else
    URL_STUB = "/images/avatars"
    DIRECTORY = File.join("public", "images", "avatars")
  end

  
  def initialize(user, image = nil)
    @user = user
    @image = image
    Dir.mkdir(DIRECTORY) unless File.directory?(DIRECTORY)    
  end
  
  def exists?
    File.exists? (File.join(DIRECTORY, filename))
  end
  
  alias exist? exists?
  
  def url
    "#{URL_STUB}/#{filename}"
  end
  
  def thumbnail_url
    thumb = exists? ? thumbnail_name : "default_thumbnail.png"
    "#{URL_STUB}/#{thumb}"
  end
  
  # Zapisuje obrazy awataru.
  def save
    valid_file? and successful_conversion?    
  end
  # Usuwa awatar z systemu plików.
  def delete
    [filename, thumbnail_name].each do |name|
      image = "#{DIRECTORY}/#{name}"
      File.delete(image) if File.exists?(image)
    end
  end
  
  private
  
  # Zwróć nazwę pliku głównego awataru.
  def filename
    "#{@user.screen_name}.png"
  end
  
  # Zwróć nazwę pliku miniatury awataru.
  def thumbnail_name
    "#{@user.screen_name}_thumbnail.png"
  end
  
  # Zwraca (zależną od platformy) ścieżkę dostępu do
  # pliku wykonywalnego convert z ImageMagick
  def convert
    if ENV["OS"] =~ /Windows/
      # Wpisz tutaj właściwy katalog ImageMagick w Windows.
      "C:\\Program Files\\ImageMagick-6.4.0-Q16\\convert"
    else
      "/usr/bin/convert"
    end    
  end
  
  # Próbuje zmienić rozmiar obrazu i przekonwertować go do PNG.
  # Do uzyskania rozsądnych rozmiarów obrazó używamy polecenia convert z ImageMagick
  def successful_conversion?
    # Przygotuj nazwy plików dla konwersji.
    source = File.join("tmp", "#{@user.screen_name}_full_size")
    full_size = File.join(DIRECTORY, filename)
    thumbnail = File.join(DIRECTORY, thumbnail_name)
    # 
    #
    File.open(source, "wb") { |f| f.write(@image.read) }
    # Konwertuj pliki
    img = system("#{convert} #{source} -resize #{IMG_SIZE} #{full_size}")
    thumb = system("#{convert} #{source} -resize #{THUMB_SIZE} #{thumbnail}")
    File.delete(source) if File.exists?(source)
    # Obydwie konwersje muszą zakończyc się powodzeniem.
    # W przeciwnym przypadku mamy błąd.
      unless img and thumb
        errors.add_to_base("Trasfer pliku zakończył się niepowodzeniem. Spróbuj przesłać inny obraz?")
        return false
      end
    return true
  end
  
  # Zwraca true dla prawdiłowego, niepustego pliku z obrazem.
  def valid_file?
    # Przesyłany plik nie powinien być pusty.
    if @image.size.zero?
      errors.add_to_base("Proszę wpisać nazwę pliku z obrazem.")
      return false
    end
    unless @image.content_type =~ /^image/
      errors.add(:obraz, "nie jest w rozpoznawanym formacie.")
      return false
    end
    if @image.size > 1.megabyte
      errors.add(:obraz, "nie może być większy niż 1 megabajt.")
      return false
    end
    return true
  end
end


