module FriendshipHelper

  # Zwraca odpowiedni komunikat o statusie znajomości.
  def friendship_status(user, friend)
    friendship = Friendship.find_by_user_id_and_friend_id(user, friend)
    return "#{friend.name} (jeszcze)nie jest Twoim znajomym." if friendship.nil?
    case friendship.status
    when 'requested'
        "#{friend.name} chciałby być Twoim znajomym."
    when 'pending'
      "Zaproponowałeś znajomość #{friend.name}"
    when 'accepted'
      "#{friend.name} jest Twoim znajomym."
    end
  end
end
