require "#{File.dirname(__FILE__)}/../test_helper"

class RememberMeTest < ActionController::IntegrationTest
  include ApplicationHelper
  
  fixtures :users
  
  def setup
    @user = users(:valid_user)
  end

  def test_remember_me
    # Logowanie z zaznaczoną opcją "pamiętaj mnie"
    post "user/login", :user => { :screen_name => @user.screen_name,
                                  :password => @user.password,
                                  :remember_me => "1" }
    # Symuluj zamknięcie przeglądarki poprzez usunięcie 
    # identyfikatora użytkownika z sesji.
    @request.session[:user_id] = nil
    # Teraz otwórz poniższą stronę
    get "site/index"
    # Powinnismy zostać zalogowani przez filtr before_filter check_authorization
    assert logged_in?
    assert_equal @user.id, session[:user_id]
  end
end
