# Zawiera zadania umożliwiające wczytanie 
# i usunięcie przykładowych danych użytkowników.
require 'active_record'
require 'active_record/fixtures'

namespace :db do
  DATA_DIRECTORY = "#{RAILS_ROOT}/lib/tasks/sample_data"
  namespace :sample_data do
    TABLES = %w(users specs faqs)
    MIN_USER_ID = 1000 # Początkowy identyfikator użytkownika w danych przykładowych.
    
    desc "Ładowanie przykładowych danych."
    task :load => :environment do |t|
      class_name = nil # Używamy nil, aby Rails sam wybrał klasę.
      TABLES.each do |table_name|
        fixture = Fixtures.new(ActiveRecord::Base.connection, 
                               table_name, class_name,  
                               File.join(DATA_DIRECTORY, table_name.to_s))
        fixture.insert_fixtures
        puts "Załadowano dane z #{table_name}.yml"
      end
    end
    
    desc "Usuwa przykładowe dane"
    task :delete => :environment do |t|
      User.delete_all("id      >= #{MIN_USER_ID}")
      Spec.delete_all("user_id >= #{MIN_USER_ID}")
      Faq.delete_all( "user_id >= #{MIN_USER_ID}")
    end
  end
end
