class Post < ActiveRecord::Base
  belongs_to :blog
  has_many :comments, :order => "created_at", :dependent => :destroy


  HUMANIZED_ATTRIBUTES = {
    :title => "Tytuł",
    :body => "Treść"
   }
   
   def self.human_attribute_name(attr)
    HUMANIZED_ATTRIBUTES[attr.to_sym] || super
   end
  
  validates_presence_of :title, :body, :blog, :message => "nie może być puste"
  validates_length_of :title, :maximum => DB_STRING_MAX_LENGTH, :message => "jest zbyt długi."
  validates_length_of :body, :maximum => DB_TEXT_MAX_LENGTH, :message => "jest zbyt długa"
  
  # Zapobiega powtarzaniu wpisów.
  validates_uniqueness_of :body, :scope => [:title, :blog_id]
  
  # Zwraca true dla powtarzających się wpisów (ten sam tytuł i treść).
  def duplicate?
    post = Post.find_by_blog_id_and_title_and_body(blog_id, title, body)
    # Nadaj sobie id dla celów trasowania REST
    self.id = post.id unless post.nil?
    not post.nil?
  end

end
