class Comment < ActiveRecord::Base
  belongs_to :user
  belongs_to :post
  
  validates_presence_of :body, :post, :user
  validates_length_of :body, :maximum => DB_TEXT_MAX_LENGTH  
  # Zapobiega duplikowaniu się komentarzy
  validates_uniqueness_of :body, :scope => [:post_id, :user_id]
  
  # Zwraca true dla powtórzonego komentarza (ten sam użytkownik i treść)
  def duplicate?
    c = Comment.find_by_post_id_and_user_id_and_body(post, user, body)
    # Nadaj sobie id, dla celów trasowania REST
    self.id = c.id unless c.nil?
    not c.nil?
  end
  
  # Sprawdź uwierzytelnienie dla celów usuwania komentarzy.
  def authorized?(user)
    post.blog.user == user
  end
end
