require 'digest/sha1'
class UserController < ApplicationController
  helper :profile, :avatar
  include ApplicationHelper
  before_filter :protect, :only => [:index, :edit]

  def index    
    @title = "RailsSpace: Centrum użytkownika"
    @user = User.find(session[:user_id])
    make_profile_vars

  end




  def register
    @title="Rejestracja"
    if param_posted?(:user)
      @user = User.new(params[:user])
      if @user.save
        @user.login!(session)
        flash[:notice] = "Utworzono konto użytkownika #{@user.screen_name}!"
        redirect_to_forwarding_url
      else
        @user.clear_password!
      end
    end
  end
  
def login
  @title = "Logowanie do RailsSpace"
  if request.get?
    @user = User.new(:remember_me => remember_me_string )
  elsif param_posted?(:user)
    @user = User.new(params[:user])
    user = User.find_by_screen_name_and_password(@user.screen_name,
                                                 @user.password)
    if user
      user.login!(session)
      @user.remember_me? ? user.remember!(cookies) : user.forget!(cookies)
      flash[:notice] = "Użytkownik #{user.screen_name} zalogowany!"
      redirect_to_forwarding_url
    else
      @user.clear_password!
      flash[:notice] = "Nieprawidłowa kombinacja użytkownika/hasła"
    end
  end
end
  
# Edycja podstawowych informacji o użytkowniku
def edit
  @title = "Edycja podstawowych informacji"
  @user = User.find(session[:user_id])
  if param_posted?(:user)
    attribute = params[:attribute]
    case attribute
      when "email"
        try_to_update @user, attribute
      when "password"
        if @user.correct_password?(params)
          try_to_update @user, attribute
         else
           @user.password_errors(params)
        end
    end
  end
  # Ze względów bezpieczeństwa nigdy nie wypełniaj pól haseł.
  @user.clear_password!
end






  def logout
    User.logout!(session, cookies)
    flash[:notice] = "Wylogowano"
    redirect_to :action => "index", :controller => "site"
  end


private
  # Chroni stronę przed nieautoryzowanym dostępem
  def protect
    unless logged_in?
      session[:protected_page] = request.request_uri
      flash[:notice] = "Proszę się zalogować!"
      redirect_to :action => "login"
      return false
    end
  end

  # Zwraca true, jeżeli przesłano parametr odpowieający danemu symbolowi.
  def param_posted?(symbol)
    request.post? and params[symbol]
  end

  # Przekierowuje do wcześniej żądanego URL (jeżeli istnieje).
  def redirect_to_forwarding_url
    if (redirect_url = session[:protected_page])
      session[:protected_page] = nil
      redirect_to redirect_url
    else
      redirect_to :action => "index"
    end
  end
# Zwraca łańcuch ze statusem pola opcji "pamiętaj mnie".
def remember_me_string
  cookies[:remember_me] || "0"
end

# Próbuje zaktualizować informacje o użytkowniku.
# Jeżeli zakończy się powodzeniem, przekierowuje do centrum użytkownika.
def try_to_update(user, attribute)
  if user.update_attributes(params[:user])
    flash[:notice] = "User #{attribute} updated."
    redirect_to :action => "index"
  end
end



end
