class SpecController < ApplicationController
  before_filter :protect
  
  def index
    redirect_to :controller => "user", :action => "index"
  end

  # Edytuje specyfikacje użytkownika
  def edit
    @title = "Edycja specyfikacji"
    @user = User.find(session[:user_id])
    @user.spec ||= Spec.new
    @spec = @user.spec
    if param_posted?(:spec)
      if @user.spec.update_attributes(params[:spec])
        flash[:notice] = "Zmiany zostały zapisane."
        redirect_to :controller => "user", :action => "index"
      end
    end
  end
end
