class ProfileController < ApplicationController
  helper :avatar, :friendship

  def index
    @title = "Profile w RailsSpace"    
  end

  def show
    @hide_edit_links = true
    screen_name = params[:screen_name]
    @user = User.find_by_screen_name(screen_name)
    @logged_in_user = User.find(session[:user_id]) if logged_in?
    if @user
      @title = "Osobisty profil #{screen_name} w RailsSpace!"
      make_profile_vars
    else
      flash[:notice] = "Użytkownik #{screen_name} nie jest zarejstrowany w RailsSpace!"
      redirect_to :action => "index"
    end
  end
end

