class PostsController < ApplicationController
  helper :profile, :avatar
  before_filter :protect, :protect_blog

  # GET /posts
  # GET /posts.xml
  def index
    @pages, @posts = paginate(@blog.posts)
    @title = "Zarządzanie blogiem"
    
    respond_to do |format|
      format.html # index.rhtml
      format.xml { render :xml => @posts.to_xml }
    end
  end

  # GET /posts/1
  # GET /posts/1.xml
  def show
    @post = Post.find(params[:id])
    @title = @post.title

    respond_to do |format|
      format.html # show.rhtml
      format.xml { render :xml => @post.to_xml }
    end
  end

  # GET /posts/new
  def new
    @post = Post.new
    @title = "Dodaj nowy wpis"
  end

  # GET /posts/1;edit
  def edit
    @post = Post.find(params[:id])
    @title = "Edytuj #{@post.title}"
  end

  # POST /posts
  # POST /posts.xml
  def create
    @post = Post.new(params[:post])

    respond_to do |format|
      if @blog.posts << @post
        flash[:notice] = 'Wpis został utworzony.'
        format.html { redirect_to blog_post_url(:id => @post) }
        format.xml { head :created, :location => blog_post_url(:id => @post) }
      else
        format.html { render :action => "new" }
        format.xml { render :xml => @post.errors.to_xml }
      end
    end
  end

  # PUT /posts/1
  # PUT /posts/1.xml
  def update
    @post = Post.find(params[:id])
    
    respond_to do |format|
      if @post.update_attributes(params[:post])
        flash[:notice] = 'Wpis został zaktualizowany.'
        format.html { redirect_to blog_post_url(:id => @post) }
        format.xml { head :ok }
      else
        format.html { render :action => "edit" }
        format.xml { render :xml => @post.errors.to_xml }
      end
    end
  end

  # DELETE /posts/1
  # DELETE /posts/1.xml
  def destroy
    @post = Post.find(params[:id])
    @post.destroy

    respond_to do |format|
      format.html { redirect_to blog_posts_url }
      format.xml { head :ok }
    end
  end

  private

  # Sprawdza czy użytkownik jest właścicielem bloga i tworzy zmienną @blog.
  def protect_blog
    @blog = Blog.find(params[:blog_id])
    user = User.find(session[:user_id])
    unless @blog.user == user
      flash[:notice] = "To nie jest Twój blog!"
      redirect_to hub_url
      return false
    end
  end
end
