class CommunityController < ApplicationController
  helper :profile

  def index
    @title = "Społeczność"
    @letters = "ABCĆDEFGHIJKLŁMNOPRSŚTUWXYZŹŻ".split("")
    if params[:id]
      @initial = params[:id]
      @pages, specs = paginate(:specs,
                         :conditions => ["last_name like ?", @initial+'%'],
                         :order => "last_name, first_name")

      @users = specs.collect { |spec| spec.user }
    end
  end

  def browse
    @title = "Przeglądaj"
   return if params[:commit].nil?
   if valid_input?
      specs = Spec.find_by_asl(params)
     @pages, @users = paginate(specs.collect {|spec| spec.user })
    end    
  end




  def search
    @title = "Szukaj w RailsSpace"
    if params[:q]
      query = params[:q]
      begin
        # Najpierw wyniki spośród użytkowników...
        @users = User.find_by_contents(query, :limit => :all)
        # ...a następnie podwyniki.
        specs = Spec.find_by_contents(query, :limit => :all)
        faqs = Faq.find_by_contents(query, :limit => :all)
    
        # Teraz połącz w jedną listę oddzielnych użytkownikow, posortowaną według nazwisk.
        hits = specs + faqs
        @users.concat(hits.collect { |hit| hit.user}).uniq!
        # Sortuj według nazwiska (wymaga specyfikacji dla każdego użytkownika).
        @users.each { |user| user.spec ||= Spec.new }
        @users = @users.sort_by { |user| user.spec.last_name }
    
        @pages, @users = paginate(@users)
      rescue Ferret::QueryParser::QueryParseException
        @invalid = true
      end
    end
  end

private
  # Zwraca true, jeżeli dane w formularzu przeglądania są prawidłowe.
  # W przeciwnym przypadku zwraca false.
  def valid_input?
    @spec = Spec.new
    # Walidacja modelu Spec (@spec.valid? poniżej) wykryje nieprawidłowe kody pocztowe.
    zip_code = params[:zip_code]
    @spec.zip_code = zip_code
    # Jest sporo kodów pocztowych, o których nie mamy informacji.
    location = GeoDatum.find_by_zip_code(zip_code)
    if @spec.valid? and not zip_code.blank? and location.nil?
      @spec.errors.add(:zip_code, "nie figuruje w naszej bazie danych")
    end 
    # Łańcuchy określające wiek powinny konwertować się do liczb całkowitych.
    unless params[:min_age].valid_int? and params[:max_age].valid_int?
      @spec.errors.add("Zakres wieku", "jest nieprawidłowy")
    end
    # Kod pocztowy jest niezbędny, jeżeli określono liczbę mil.
    miles = params[:miles]
    if miles and not zip_code
      @spec.errors.add(:zip_code, "nie może być puste")
    end
    # Liczba mil powinna konwertować się do poprawnej liczby zmiennoprzecinkowej.
    unless miles.nil? or miles.valid_float?
      @spec.errors.add("Promień", "jest nieprawidłowy")
    end
    # Dane wejściowe są poprawne, jeżeli obiekt errors jest pusty.
    @spec.errors.empty?
  end
end
