class AvatarController < ApplicationController
  before_filter :protect
  
  def index
    redirect_to hub_url
  end

  def upload
    @title ="Prześlij swój awatar"
    @user = User.find(session[:user_id])
   if param_posted?(:avatar)
    image = params[:avatar][:image]
    @avatar = Avatar.new(@user, image)
      if @avatar.save
        flash[:notice] = "Twój awatar został zapisany."
        redirect_to hub_url
      end
    end
  end


  # Usuwa awatar
  def delete
    user = User.find(session[:user_id])
    user.avatar.delete
    flash[:notice] = "Twój awatar został usunięty."
    redirect_to hub_url
  end
end
