# Filters added to this controller apply to all controllers in the application.
# Likewise, all the methods added will be available for all controllers.

class ApplicationController < ActionController::Base
  helper :all # include all helpers, all the time
  include ApplicationHelper
  before_filter :check_authorization

  protect_from_forgery  :secret => 'a0eb34fe2f95d34c9b4035eb8c3cabde'
  
   # Wybierz unikatową nazwę pliku cookie, aby odróżnić dane naszej sesji spośród innych
  session :session_key => '_rails_space_session_id'
  
  # Sprawdź, czy istnieje poprawny plik cookie, ewentualnie zaloguj użytkownika
  def check_authorization
    authorization_token = cookies[:authorization_token]
    if cookies[:authorization_token] and not logged_in?
      user = User.find_by_authorization_token(authorization_token)
      user.login!(session) if user
    end
  end
  
  # Zwraca true, jeżeli przesłany został parametr odpowiadający podanemu symbolowi.
  def param_posted?(sym)
    request.post? and params[sym]
  end

# Chroni stronę przed nieautoryzowanym dostępem
  def protect
    unless logged_in?
      session[:protected_page] = request.request_uri
      flash[:notice] = "Proszę się zalogować!"
      redirect_to :controller => "user", :action => "login"
      return false
    end
  end
  
  # Paginuj listę, jeśli jest dostępna, 
  # w przeciwnym przypadku wywołaj domyślną metodę paginate.
  def paginate(arg, options = {})
    if arg.instance_of?(Symbol) or arg.instance_of?(String)
      # Użyj domyślnej funckji paginate.
      collection_id = arg # arg is, e.g., :specs or "specs"
      super(collection_id, options)
    else  
      # Paginacja ręczna.
      items = arg # arg jest listą elemntów, e.g., users
      items_per_page = options[:per_page] || 10
      page = (params[:page] || 1).to_i
      result_pages = Paginator.new(self, items.length, items_per_page, page)
      offset = (page - 1) * items_per_page
      [result_pages, items[offset..(offset + items_per_page - 1)]]
    end
  end

def make_profile_vars
  @spec = @user.spec ||= Spec.new
  @faq = @user.faq ||= Faq.new
  @blog = @user.blog ||= Blog.new
  @pages, @posts = paginate(@blog.posts, :per_page => 3)
end

  
end
