#---
# Excerpted from "Rails Recipes"
# We make no guarantees that this code is fit for any purpose. 
# Visit http://www.pragmaticprogrammer.com/titles/fr_rr for more book information.
#---
class ExportController < ApplicationController
  def orders
    content_type = if request.user_agent =~ /windows/i
                     'application/vnd.ms-excel'
                   else
                     'text/csv'
                   end
     
    CSV::Writer.generate(output = "") do |csv|
      Order.find(:all).each do |order|
        csv << [order.id, order.price, order.purchaser, order.created_at]
      end
    end
    send_data(output, 
                :type => content_type, 
                :filename => "orders.csv")
  end
end
