#---
# Excerpted from "Rails Recipes"
# We make no guarantees that this code is fit for any purpose. 
# Visit http://www.pragmaticprogrammer.com/titles/fr_rr for more book information.
#---
class Notifier < ActionMailer::Base

  def multipart_alternative(recipient, name, sent_at = Time.now)
    subject      "Co dla kadego."
    recipients   recipient
    from         'barnam@chadfowler.com'
    sent_on      sent_at
    content_type "multipart/alternative" 

    part :content_type => "text/plain", 
      :body => render_message("multipart_alternative_plain", :name => name)

    part :content_type => "text/html", 
      :body => render_message("multipart_alternative", :name => name)
  end


  def implicit_multipart(recipient, name, sent_at = Time.now)
    subject      "Co dla kadego."
    recipients   recipient
    from         'barnam@chadfowler.com'
    sent_on      sent_at
    body(:name => name)
  end

end
