#---
# Excerpted from "Rails Recipes"
# We make no guarantees that this code is fit for any purpose. 
# Visit http://www.pragmaticprogrammer.com/titles/fr_rr for more book information.
#---
class ApplicationController < ActionController::Base
  def user2utc(time)
    current_user.tz.unadjust(time)
  end
  
  def utc2user(time)
    current_user.tz.adjust(time)
  end
  
  def current_user
    User.find(session[:user])
  end
end
