"""
Wersja 4.0 biblioteki gensim, która została wydana 
25 marca 2021 roku, przestałą wspierać moduł podsumowań.
Aby używać tego programu, zainstaluj bibliotekę 
gensim w wersji 3.8.3 (https://pypi.org/project/gensim/3.8.3/)
"""

import requests
import bs4
from gensim.summarization import summarize

url = 'https://jamesclear.com/great-speeches/make-your-bed-by-admiral-william-h-mcraven'

page = requests.get(url)
page.raise_for_status()
soup = bs4.BeautifulSoup(page.text, 'html.parser')
p_elems = [element.text for element in soup.find_all('p')]
speech = ' '.join(p_elems)  # Pamiętaj połączyć spacjami!

print("\nStreszczenie przemówienia Make Your Bed:")

# Uwaga: aktualizacja względem pierwszego wydania
summary = summarize(speech, word_count=225)
sentences = sent_tokenize(summary)
sents = set(sentences)
print(' '.join(sents))
