﻿################
## LISTING 38.1
################
import tkinter 
window = tkinter.Tk()
window.geometry("800x800")
window.title("Berek!")
canvas = tkinter.Canvas(window)           #A
canvas.pack(expand=1, fill='both')        #B
#A Widżet kanwa, który będzie zawierał figury graczy
#B Dodaje kanwę w taki sposób, aby wypełniała ona całe okno i podlegała skalowaniu, jeśli okno zmieni wymiar



################
## LISTING 38.2
################
import random
class Player(object):
    def __init__(self, canvas, color):            #A
        self.color = color                        #B
        size = random.randint(1,100)              #C
        x1 = random.randint(100,700)              #D
        y1 = random.randint(100,700)              #E
        x2 = x1+size                              #F
        y2 = y1+size                              #G
        self.coords = [x1, y1, x2, y2]            #H
        self.piece = canvas.create_rectangle(self.coords)        #I
        canvas.itemconfig(self.piece, fill=color)                #J
#A Metoda init, która tworzy obiekt na kanwie i określa jego kształt oraz kolor
#B Ustawia kolor obiektu jako atrybut
#C Wybiera losową liczbę pomiędzy 1 a 100 jako rozmiar figury gracza
#D Wartość x dla rogu po lewej u góry wybrana losowo z określonego przedziału
#E Wartość y dla rogu po lewej u góry wybrana losowo z określonego przedziału
#F Wartość x współrzędnych po prawej u dołu
#G Wartość y współrzędnych po prawej u dołu
#H Ustawia współrzędne obiektu jako jego atrybuty za pośrednictwem listy
#I Ustawia atrybut figury gracza, umiejscawiając go w pozycji wskazanej przez powyższe współrzędne
#J Ustawia kolor figury gracza, odnosząc się do nazwy zmiennej z poprzedniej linii self.piece



################
## LISTING 38.3
################
def handle_key(event):                    #A
    if event.char == 'w' :                #B
        player1.move("u")                 #C
    if event.char == 's' :
        player1.move("d")
    if event.char == 'a' :
        player1.move("l")
    if event.char == 'd' :
        player1.move("r")
    if event.char == 'i' :                 #D
        player2.move("u")                  #E
    if event.char == 'k' :
        player2.move("d")
    if event.char == 'j' :
        player2.move("l")
    if event.char == 'l' :
        player2.move("r")
          
window = tkinter.Tk()
window.geometry("800x800")
window.title("Berek!")
canvas = tkinter.Canvas(window)
canvas.pack(expand=1, fill='both')

player1 = Player(canvas, "yellow")
player2 = Player(canvas, "blue")
canvas.bind_all('<Key>', handle_key)           #F
#A Funkcja obsługi zdarzenia
#B Sprawdza, czy wciśnięto klawisz W
#C move to metoda, którą zdefiniujesz w klasie gracza. Wywołasz tę metodę, aby przesunąć figurę
#D Sprawdza, czy wciśnięto klawisz I
#E Ponieważ move jest zdefiniowana w klasie gracza, wywołasz ją, aby przesunąć figurę drugiego gracza
#F Na kanwie każde wciśnięcie klawisza spowoduje wywołanie funkcji handle_key


################
## LISTING 38.4
################
class Player(object):
    def __init__(self, canvas, color):
        size = random.randint(1,100)
        x1 = random.randint(100,700)
        y1 = random.randint(100,700)
        x2 = x1+size
        y2 = y1+size
        self.color = color
        self.coords = [x1, y1, x2, y2]
        self.piece = canvas.create_rectangle(self.coords, tags=color)
        canvas.itemconfig(self.piece, fill=color)

    def move(self, direction):                           #A
        if direction == 'u':                             #B
            self.coords[1] -= 10                         #C
            self.coords[3] -= 10                         #C
            canvas.coords(self.piece, self.coords)       #D
        if direction == 'd':
            self.coords[1] += 10
            self.coords[3] += 10
            canvas.coords(self.piece, self.coords)
        if direction == 'l':
            self.coords[0] -= 10
            self.coords[2] -= 10
            canvas.coords(self.piece, self.coords)
        if direction == 'r':
            self.coords[0] += 10
            self.coords[2] += 10
            canvas.coords(self.piece, self.coords)
#A Metoda, która porusza figurą w określonym kierunku: 'u', 'd', 'l', 'r'
#B Zrobi coś innego dla każdego z możliwych wariantów ('u', 'd', 'l', 'r')
#C Jeśli przesuwasz figurę, zmienia wartości y1 oraz y2 przez powiększenie współrzędnych na liście
#D Zmienia współrzędne prostokąta, określone przez self.piece


################
## LISTING 38.5
################
def handle_key(event):
    yellow_xy = canvas.bbox(1)                                          #A
    overlapping = canvas.find_overlapping(
                   yellow_xy[0],yellow_xy[1],yellow_xy[2],yellow_xy[3]) #B
    if 2 in overlapping:                                                #C
        canvas.create_text(100,100,font=("Arial",20),text="Berek!")     #D
#A Pobiera współrzędne jednej z figur
#B Ustala ID figur, które znajdują się wewnątrz ramki utworzonej na podstawie tych współrzędnych
#C Sprawdza, czy ID drugiej figury nachodzi na ID pierwszej
#D Dodaje tekst do kanwy
