﻿################
## LISTING 29.1
################
def read_text(filename):
    """                                                             #A
    filename: ciąg znaków, nazwa pliku, który ma być zaczytany      #A
    zwraca: ciąg znaków, zawierający całą zawartość pliku           #A
    """                                                   #A
    inFile = open(filename, 'r')                          #B
    line = inFile.read()                                  #C
    return line                                           #D

text = read_text("sonnet18.txt")                          #E
print(text)
#A Docstring
#B Funkcja Pythona, która otwiera plik poprzez użycie jego nazwy
#C Funkcja Pythona, która zaczytuje całą zawartość jako ciąg znaków
#D Zwraca ciąg znaków
#E Wywołanie funkcji







################
## LISTING 29.2
################
import string                                      #A

def find_words(text):
    """
    text: string
    zwraca: listę słów pochodzących ze wprowadzonego tekstu    
    """
    text = text.replace("\n", " ")               #B
    for char in string.punctuation:              #C
        text = text.replace(char, "")            #D

    words = text.split(" ")                      #E
    return words                                 #F

words = find_words(text)                         #G
#A Dostarcza zestawu funkcji, których można używać na ciągach znaków
#B Zamienia znaki nowej linii na spacje
#C Używa predefiniowanego zestawu znaków
#D Zamienia znaki specjalne na puste ciągi
#E Tworzy listę wszystkich słów, opierając się na znaku spacji
#F Zwraca listę słów
#G Wywołuje funkcję



################
## LISTING 29.3
################
def frequencies(words):
    """
    words: lista słów
    zwraca: częstotliwość wystąpienia wprowadzonego słowa    
    """
    freq_dict = {}                              #A

    for word in words:                          #B
        if word in freq_dict:                   #C
            freq_dict[word] += 1                #D
        else:                                   #E
            freq_dict[word] = 1                 #F
       return freq_dict                         #G

freq_dict = frequencies(words)                  #H
#A Inicjalizuje pusty słownik
#B Wyszukuje każde słowo w liście
#C Jeśli słowo już jest w słowniku…
#D …dodaje jeden do jego liczby
#E Jeśli słowa nie ma jeszcze w słowniku,
#F dodaje słowo i ustawia jego liczbę na 1
#G Zwraca słownik
#H Wywołanie funkcji





################
## LISTING 29.4
################
def calculate_similarity(dict1, dict2):
    """
    dict1: słownik przechowujący liczbę wystąpień słów w tekście
    dict2: słownik przechowujący liczbę wystąpień słów w innym tekście
    zwraca: liczba zmiennoprzecinkowa, pokazuje stopień podobieństwa dwóch tekstów
    """
    diff = 0
    total = 0

    for word in dict1.keys():                               #A
        if word in dict2.keys():                            #B
            diff += abs(dict1[word] - dict2[word])          #C
        else:                                               #D
            diff += dict1[word]                             #E

    for word in dict2.keys():                                #F
        if word not in dict1.keys():                         #G
            diff += dict2[word]                              #H

    total = sum(dict1.values()) + sum(dict2.values())        #I
    difference = diff / total                                #J
    similar = 1.0 – difference                               #K

    return round(similar, 2)                                 #L
#A Przechodzi przez słowa w jednym słowniku
#B Słowo w obu słownikach
#C Dodaje różnicę w częstotliwości wystąpień
#D Słowo nie występuje w drugim słowniku
#E Dodaje całą liczbę wystąpień
#F Przechodzi przez słowa w drugim słowniku
#G Zliczone słowo w obu słownikach. Uwzględnia tylko te słowa, których brak w dict1
#H Dodaje całkowitą liczbę wystąpień
#I Całkowita liczba słów w obu słownikach
#J Dzieli różnicę przez całkowitą liczbę słów
#K Odejmuje różnicę od 1
#L Zaokrągla do dwóch miejsc po przecinku i zwraca wynik z zakresu pomiędzy 0 a 1



################
## LISTING 29.5
################
text_1 = read_text("sonnet18.txt")
text_2 = read_text("sonnet19.txt")
words_1 = find_words(text_1)
words_2 = find_words(text_2)
freq_dict_1 = frequencies(words_1)
freq_dict_2 = frequencies(words_2) 
print(calculate_similarity(freq_dict_1, freq_dict_2))
