﻿################
## LISTING 32.1
################
class Stack(object):
    def __init__( self):
        self.stack = []                   #A
    def get_stack_elements(self):
        return self.stack.copy()          #B
    def add_one(self , item):
        self.stack.append(item)           #C
    def add_many(self , item, n):
        for i in range(n):                #D
            self.stack.append(item)       #D
    def remove_one(self):
        self.stack.pop()                  #E
    def remove_many(self , n):
        for i in range(n):                #F
            self.stack.pop()              #F
    def size(self):
        return len(self.stack)            #G
    def prettyprint(self):
        for thing in self.stack[::-1]:    #H
            print('|_',thing, '_|')       #H
#A Atrybut, będący listą, definiuje stos
#B Metoda, która zwraca kopię atrybutu reprezentującego stos
#C Metoda, która dodaje jeden element do stosu; dodaje go na koniec listy
#D Metoda, która dodaje n tych samych elementów do stosu
#E Metoda, która usuwa jeden element ze stosu
#F Metoda, która usuwa n elementów ze stosu
#G Metoda, która podaje liczbę elementów w stosie
#H Metoda, która drukuje stos, z każdym elementem w linii, gdzie najnowsze elementy są wyświetlone na górze





################
## LISTING 32.2
################
pancakes = Stack()                        #A
pancakes.add_one("borówkowe")             #B
pancakes.add_many("czekoladowe", 4)       #C
print(pancakes.size())                    #D
pancakes.remove_one()                     #E
print(pancakes.size())                    #F
pancakes.prettyprint()                    #G
#A Tworzy stos i dowiązuje obiekt Stack do zmiennej o nazwie pancakes
#B Dodaje jedno ciastko borówkowe
#C Dodaje cztery ciastka czekoladowe
#D Wyświetla liczbę pięć
#E Usuwa ciąg, który został dodany jako ostatni, czyli ciastko czekoladowe
#F Wyświetla liczbę cztery
#G Drukuje każdy smak ciastka w linii: trzy czekoladowe na górze i jedno borówkowe na dole





################
## LISTING 32.3
################
circles  = Stack()                        #A
one_circle = Circle()                     #B
one_circle.change_radius(2)               #B
circles.add_one(one_circle)               #B

for i in range(5):                        #C
    one_circle = Circle()                 #D
    one_circle.change_radius(1)           #D
    circles.add_one(one_circle)           #D

print(circles.size())                     #E
circles.prettyprint()                     #F
#A Tworzy stos i owiązuje obiekt Stack do zmiennej o nazwie circles
#B Tworzy nowy obiekt okręgu, ustawia wartość jego promienia na 2 i dodaje okręg do stosu
#C Pętla, która dodaje pięć nowych obiektów okręgu
#D Tworzy nowy obiekt okręgu za każdym wykonaniem pętli, ustawia promień na 1 i dodaje go   do stosu
#E Wyświetla liczbę sześć
#F Wyświetla informację Pythona, która odnosi się do każdego obiektu okręgu (jego typ i lokalizację w pamięci)


################
## LISTING 32.4
################
circles  = Stack()                        #A
one_circle = Circle()                     #A
one_circle.change_radius(2)               #A
circles.add_one(one_circle)               #A

one_circle = Circle()                     #B
one_circle.change_radius(1)               #B
circles.add_many(one_circle, 5)           #C

print(circles.size())                     #D
circles.prettyprint()                     #E
#A Operacje takie same jak na listingu 32.3
#B Tworzy nowy obiekt okrąg; ustawia wartość jego promienia na 1
#C Dodaje te same obiekty okrąg pięć razy za pomocą metody zdefiniowanej w klasie Stack
#D Wyświetla liczbę sześć — całkowitą liczbę okręgów dodanych do chwili obecnej
#E Wyświetla informacje Pythona odnoszące się do każdego obiektu okrąg (jego typ i lokalizację w pamięci)
