from sklearn.datasets import load_breast_cancer
cancer_data = load_breast_cancer()

X = cancer_data.data
Y = cancer_data.target

print('Wielkość zbioru wejściowego:', X.shape)
print('Wielkość zbioru wyjściowego', Y.shape)
print('Etykiety:', cancer_data.target_names)
n_pos = (Y == 1).sum()
n_neg = (Y == 0).sum()
print(f'Liczba próbek pozytywnych:{n_pos}, negatywnych:{n_neg}.')

from sklearn.model_selection import train_test_split
X_train, X_test, Y_train, Y_test = train_test_split(X, Y, random_state=42)

from sklearn.svm import SVC
clf = SVC(kernel='linear', C=1.0, random_state=42)
clf.fit(X_train, Y_train)
accuracy = clf.score(X_test, Y_test)
print(f'The accuracy is: {accuracy*100:.1f}%')

from sklearn.datasets import load_wine
wine_data = load_wine()
X = wine_data.data
Y = wine_data.target

print('Wielkość zbioru wejściowego:', X.shape)
print('Wielkość zbioru wyjściowego:', Y.shape)
print('Etykiety:', wine_data.target_names)
n_class0 = (Y == 0).sum()
n_class1 = (Y == 1).sum()
n_class2 = (Y == 2).sum()
print(f'{n_class0} class0 samples,\n{n_class1} class1 samples,\n{n_class2} class2 samples.')

X_train, X_test, Y_train, Y_test = train_test_split(X, Y, random_state=42)

clf = SVC(kernel='linear', C=1.0, random_state=42)
clf.fit(X_train, Y_train)
accuracy = clf.score(X_test, Y_test)
print(f'Dokładność: {accuracy*100:.1f}%')

from sklearn.metrics import classification_report
pred = clf.predict(X_test)
print(classification_report(Y_test, pred))