from sklearn.feature_extraction import DictVectorizer

X_dict = [{'zainteresowania': 'technika', 'zawód': 'specjalista'},
          {'zainteresowania': 'moda', 'zawód': 'student'},
          {'zainteresowania': 'moda', 'zawód': 'specjalista'},
          {'zainteresowania': 'sport', 'zawód': 'student'},
          {'zainteresowania': 'technika', 'zawód': 'student'},
          {'zainteresowania': 'technika', 'zawód': 'emeryt'},
          {'zainteresowania': 'sport', 'zawód': 'specjalista'}]

dict_one_hot_encoder = DictVectorizer(sparse=False)
X_encoded = dict_one_hot_encoder.fit_transform(X_dict)
print(X_encoded)

print(dict_one_hot_encoder.vocabulary_)

new_dict = [{'interest': 'sports', 'occupation': 'retired'}]
new_encoded = dict_one_hot_encoder.transform(new_dict)
print(new_encoded)

print(dict_one_hot_encoder.inverse_transform(new_encoded))

# new category not encountered before
new_dict = [{'interest': 'unknown_interest', 'occupation': 'retired'},
            {'interest': 'tech', 'occupation': 'unseen_occupation'}]
new_encoded = dict_one_hot_encoder.transform(new_dict)
print(new_encoded)

import pandas as pd
df = pd.DataFrame({'score': ['low',
                             'high',
                             'medium',
                             'medium',
                             'low']})
print(df)

mapping = {'low':1, 'medium':2, 'high':3}
df['score'] = df['score'].replace(mapping)

print(df)