from flask import Flask, session, render_template, request

import os
import klubplywacki

app = Flask(__name__)
app.secret_key = "Nigdy mnie nie odgadniesz..."

@app.get("/")
def index():
    return render_template(
        "index.html",
        title="Witamy w aplikacji internetowej klubu pływackiego",
    )


def populate_data():
    if "swimmers" not in session:
        swim_files = os.listdir(klubplywacki.FOLDER)
        swim_files.remove(".DS_Store")
        session["swimmers"] = {}
        for file in swim_files:
            name, *_ = klubplywacki.read_swim_data(file)
            if name not in session["swimmers"]:
                session["swimmers"][name] = []
            session["swimmers"][name].append(file)


@app.get("/plywacy")
def display_swimmers():
    populate_data()
    return render_template(
        "select.html",
        title="Wybierz pływaka",
        url="/pokazpliki",
        select_id="swimmer",
        select_text="pływaka", 
        data=sorted(session["swimmers"]),  
    )


@app.post("/pokazpliki")
def display_swimmers_files():
    populate_data()
    name = request.form["swimmer"]
    return render_template(
        "select.html",
        title="Wybierz konkurencję",
        url="/pokazwykres",
        select_id="file",
        select_text="plik z danymi",
        data=session["swimmers"][name], 
    )

@app.post("/pokazwykres")
def show_bar_chart():
    file_id = request.form["file"]
    location = klubplywacki.produce_bar_chart(file_id, "templates/")
    return render_template(location.split("/")[-1])


if __name__ == "__main__":    app.run(debug=True)
