import gazpacho
import json

URL = "https://pl.wikipedia.org/wiki/Rekordy_świata_w_pływaniu"
RECORDS = (0, 1, 3, 4)
COURSES = ("Mężczyźni, basen 50 m", "Kobiety, basen 50 m", 
           "Mężczyźni, basen 25 m", "Kobiety, basen 25 m")
WHERE = "/home/pythonruszglowa/webapp/"
## WHERE = ""
JSONDATA = "rekordy.json"

html = gazpacho.get(URL)
soup = gazpacho.Soup(html)
tables = soup.find("table")
records = {}
for table, course in zip(RECORDS, COURSES):
    records[course] = {}
    for row in tables[table].find("tr")[1:]:
        columns = row.find("td")
        event = columns[0].text.replace("\xa0", " ")    # ostatnie wywołanie, .replace(...), zastępuje spację "niełamiącą" normalną
        time = columns[1].text
        if "×" not in event:
            records[course][event] = time            
with open(WHERE + JSONDATA, "w") as jf:
    json.dump(records, jf)