﻿
from flask import Flask, render_template, request, escape
from vsearch import search4letters

from DBcm import UseDatabase, ConnectionError, CredentialsError, SQLError
from checker import check_logged_in

import mysql.connector

app = Flask(__name__)

app.config['dbconfig'] = {'host': '127.0.0.1',
                          'user': 'vsearch',
                          'password': 'vsearchpasswd',
                          'database': 'vsearchlogDB', }


@app.route('/login')
def do_login() -> str:
   session['logged_in'] = True
   return 'Teraz jesteś zalogowany.'


@app.route('/logout')
def do_logout() -> str:
   session.pop('logged_in')
   return 'Teraz jesteś wylogowany.'


def log_request(req: 'flask_request', res: str) -> None:
   """Loguje szczegóły żądania sieciowego oraz wyniki."""

   # raise Exception("Właśnie stało się coś okropnego.")

   with UseDatabase(app.config['dbconfig']) as cursor:
      _SQL = """insert into log
                (phrase, letters, ip, browser_string, results)
                values
                (%s, %s, %s, %s, %s)"""
      cursor.execute(_SQL, (req.form['phrase'],
                            req.form['letters'],
                            req.remote_addr,
                            req.user_agent.browser,
                            res, ))


@app.route('/search4', methods=['POST'])
def do_search() -> 'html':
   """Wydobywa przekazane dane; przeprowadza wyszukiwanie; zwraca wyniki."""
   phrase = request.form['phrase']
   letters = request.form['letters']
   title = 'Oto Twoje wyniki:'
   results = str(search4letters(phrase, letters))
   try:
      log_request(request, results)
   except Exception as err:
      print('***** Logowanie się nie powiodło; wystąpił błąd:', str(err))
   return render_template('results.html',
                          the_title=title,
                          the_phrase=phrase,
                          the_letters=letters,
                          the_results=results,)


@app.route('/')
@app.route('/entry')
def entry_page() -> 'html':
   """Wyświetla formularz HMTL tej aplikacji WWW."""
   return render_template('entry.html',
                          the_title='Witamy na stronie internetowej search4letters!')


@app.route('/viewlog')
@check_logged_in
def view_the_log() -> 'html':
   """Wyświetla zawartość pliku logu w tabeli HTML."""
   try:
      with UseDatabase(app.config['dbconfig']) as cursor:
         _SQL = """select phrase, letters, ip, browser_string, results
                   from logerror"""
         cursor.execute(_SQL)
         contents = cursor.fetchall()
      titles = ('Fraza' , 'Litery' , 'Adres klienta', 'Agent użytkownika', 'Wyniki')
      return render_template('viewlog.html',
                             the_title='View Log',
                             the_row_titles=titles,
                             the_data=contents,)

   ### Nie rób tego, ponieważ ściśle sprzęga to Twój kod z bazą MySQL. ###
   except mysql.connector.errors.InterfaceError as err:
      print('Czy Twoja baza danych jest włączona? Błąd:', str(err))
   except Exception as err:
      print('Coś poszło źle:', str(err))
      raise err
   return 'Błąd'

   
app.secret_key = 'NigdyNieZgadnieszMojegoTajnegoKlucza'

if __name__ == '__main__':
    app.run(debug=True)
