import itertools
import codecs
import glob

# Wyczyszczenie nieprzetworzonych list wyrazów do postaci pojedynczego pliku liczącego 500 000 unikalnych wyrazów

# "Listy wyrazów Moby. Autor: Grady Ward"
# http://www.gutenberg.org/ebooks/3201
LONG_FILES = glob.glob('mword10/*')
SUMMARISED_FILE = "all_unique_words.txt"


def read_words(filename):
    # Zwraca wyrazy z pliku za pomocą generatora
    try:
        with codecs.open(filename, 'r', 'Windows-1252') as f:
            for line_nbr, line in enumerate(f):
                items = line.strip().split()
                for item in items:
                    yield item
    except UnicodeDecodeError:
        print "Błąd UnicodeDecodeError dla {} w pobliżu wiersza {} i wyrazu {}".format(filename, line_nbr, line)

readers = itertools.chain(*(read_words(lf) for lf in LONG_FILES))

if __name__ == "__main__":
    words_set = set(readers)
    print "Zebranie plików wejściowych w jednym zbiorze wyjściowym {} wyrazów.".format(len(words_set))
    with codecs.open(SUMMARISED_FILE, 'w', 'Windows-1252') as f:
        for word in words_set:
            f.write(word + "\n")
