"""Generator zbioru Julii bez opcjonalnego rysowania obrazów na bazie biblioteki PIL"""
import time
import shedskinfn

# Obszar przestrzeni zespolonej do przeanalizowania
x1, x2, y1, y2 = -1.8, 1.8, -1.8, 1.8
c_real, c_imag = -0.62772, -.42193


def calc_pure_python(desired_width, max_iterations):
    """Tworzenie listy współrzędnych zespolonych (zs) i parametrów zespolonych (cs), budowanie zbioru Julii i wyświetlanie danych"""
    x_step = (float(x2 - x1) / float(desired_width))
    y_step = (float(y1 - y2) / float(desired_width))
    x = []
    y = []
    ycoord = y2
    while ycoord > y1:
        y.append(ycoord)
        ycoord += y_step
    xcoord = x1
    while xcoord < x2:
        x.append(xcoord)
        xcoord += x_step
    # Utwórz listę współrzędnych i warunek początkowy dla każdej komórki.
    # Zauważ, że warunek początkowy to stała, która z łatwością może zostać usunięta.
    # Stała służy do symulowania rzeczywistego scenariusza z kilkoma wejściami
    # przekazanymi przykładowej funkcji.
    zs = []
    cs = []
    for ycoord in y:
        for xcoord in x:
            zs.append(complex(xcoord, ycoord))
            cs.append(complex(c_real, c_imag))

    print "Długość dla x:", len(x)
    print "Łączna liczba elementów:", len(zs)
    start_time = time.time()
    output = shedskinfn.calculate_z(max_iterations, zs, cs)
    end_time = time.time()
    secs = end_time - start_time
    print "Czas działania:", secs, "s"

    validation_sum = sum(output)
    print "Łączna suma elementów (do sprawdzenia poprawności):", validation_sum


# Obliczanie zbioru Julii za pomocą czystego rozwiązania opartego na języku Python
# z wykorzystaniem wartości domyślnych rozsądnych dla laptopa.
calc_pure_python(desired_width=1000, max_iterations=300)
