import time
import timeit
import text_example
import memory_profiler
import dawg

if __name__ == "__main__":
    print "Zajęta pamięć RAM przy uruchamianiu: {:0.1f} MiB".format(memory_profiler.memory_usage()[0])
    # Unikaj budowania tymczasowej listy słów za pomocą kodu Python. Listę przechowuj bezpośrednio w
    # grafie DAWG.
    t1 = time.time()
    words_dawg = dawg.DAWG(text_example.readers)
    t2 = time.time()
    print "Zużycie pamięci RAM po utworzeniu grafu DAWG: {:0.1f} MiB. Czas trwania: {:0.1f} s.".format(memory_profiler.memory_usage()[0], t2 - t1)

    assert u'Zwiebel' in words_dawg
    time_cost = sum(timeit.repeat(stmt="u'Zwiebel' in words_dawg",
                                  setup="from __main__ import words_dawg",
                                  number=1,
                                  repeat=10000))
    print "Łączny czas wyszukiwania słowa: {:0.4f} s".format(time_cost)
