import time
import numpy as np
from numba import autojit


@autojit()
def y_is_in_circle(x, y):
    """Sprawdzenie, czy współrzędna x,y znajduje się w obrębie promienia koła jednostkowego"""
    return x * x + y * y <= 1.0


nbr_samples = int(1e7)
xs = np.random.uniform(size=nbr_samples)
ys = np.random.uniform(size=nbr_samples)
t1 = time.time()
nbr_in_circle = y_is_in_circle(xs, ys)
print "Czas trwania: {} s".format(time.time() - t1)
nbr_in_circle = float(np.sum(nbr_in_circle))
print nbr_in_circle

pi_estimate = nbr_in_circle / nbr_samples * 4
print pi_estimate
print np.pi
