"""Wykres - czas wykonywania dla wariantów przybliżenia liczby Pi za pomocą list opartych na wykonywaniu szeregowym, wątkach i procesach"""
import numpy as np
import matplotlib.pyplot as plt

# Czasy wygenerowane za pomocą funkcji
#  pi_lists_parallel
speeds = np.array([[110.0],
                   [118.0, 144.0, 149.0, 150.0],
                   [110.0, 55.0, 28.0, 27.0]])

nbr_cores = np.array([[1],
                      [1, 2, 4, 8],
                      [1, 2, 4, 8]])

labels = np.array(["Wykonywanie szeregowe", "Wątki", "Procesy"])

plt.figure(1)
plt.clf()
markers = ['-.o', '--x', '-x']
for nc, sp, label, mk in zip(nbr_cores, speeds, labels, markers):
    plt.plot(nc, sp, mk, label=label, linewidth=2)
plt.annotate("W przypadku wykonywania szeregowego i jednego procesu czas wykonywania jest identyczny",
             (nbr_cores[0][0] + 0.1, speeds[0][0]))
plt.legend(loc="lower left", framealpha=0.8)
plt.ylim(20, 155)
plt.xlim(0.5, 8.5)
plt.ylabel("Czas wykonywania (sekundy) – im krótszy, tym lepiej")
plt.xlabel("Liczba procesów roboczych")
plt.title(
    "Czas przybliżenia liczby Pi za pomocą obiektów z 100 000 000\nrzutek w przypadku wykonywania szeregowego, wątków i procesów")
# plt.grid()
# plt.show()
plt.tight_layout()
plt.savefig("08_pi_lists_graph_speed_tests_threaded_processes.png")
