"""Generator zbioru Julii bez opcjonalnego rysowania obrazów na bazie biblioteki PIL"""
import time

# Obszar przestrzeni zespolonej do przeanalizowania
x1, x2, y1, y2 = -1.8, 1.8, -1.8, 1.8
c_real, c_imag = -0.62772, -.42193


def launch_memory_usage_server(port=8080):
    import cherrypy
    import dowser

    cherrypy.tree.mount(dowser.Root())
    cherrypy.config.update({
        'environment': 'embedded',
        'server.socket_port': port
    })

    cherrypy.engine.start()


def calculate_z_serial_purepython(maxiter, zs, cs):
    """Obliczanie listy output przy użyciu reguły aktualizacji zbioru Julii"""
    output = [0] * len(zs)
    for i in range(len(zs)):
        n = 0
        z = zs[i]
        c = cs[i]
        while n < maxiter and abs(z) < 2:
            z = z * z + c
            n += 1
        output[i] = n
    return output


def calc_pure_python(draw_output, desired_width, max_iterations):
    """Tworzenie listy współrzędnych zespolonych (zs) i parametrów zespolonych (cs), budowanie zbioru Julii i wyświetlanie danych"""
    x_step = (float(x2 - x1) / float(desired_width))
    y_step = (float(y1 - y2) / float(desired_width))

    x = []
    y = []
    ycoord = y2
    while ycoord > y1:
        y.append(ycoord)
        ycoord += y_step
    xcoord = x1
    while xcoord < x2:
        x.append(xcoord)
        xcoord += x_step

    # Ustawianie szerokości i wysokości na liczby wygenerowanych pikseli, zamiast
    # wstępnie zaokrąglanej żądanej szerokości i wysokości.
    # Utwórz listę współrzędnych i warunek początkowy dla każdej komórki.
    # Zauważ, że warunek początkowy to stała, która z łatwością może zostać usunięta.
    # Stała służy do symulowania rzeczywistego scenariusza z kilkoma wejściami
    # przekazanymi przykładowej funkcji.
    zs = []
    cs = []
    for ycoord in y:
        for xcoord in x:
            zs.append(complex(xcoord, ycoord))
            cs.append(complex(c_real, c_imag))

    launch_memory_usage_server()

    print "Długość dla x:", len(x)
    print "Łączna liczba elementów:", len(zs)
    start_time = time.time()
    output = calculate_z_serial_purepython(max_iterations, zs, cs)
    end_time = time.time()
    secs = end_time - start_time
    print "Działanie funkcji " + calculate_z_serial_purepython.func_name + " trwało", secs, "s"

    # Suma ta jest oczekiwana dla siatki 1000^2 z 300 iteracjami.
    assert sum(output) == 33219980

    print "Oczekiwanie..."
    while True:
        time.sleep(1)


if __name__ == "__main__":
    # Obliczanie zbioru Julii za pomocą czystego rozwiązania opartego na języku Python
    # z wykorzystaniem wartości domyślnych rozsądnych dla laptopa.
    # Ustawienie draw_output na wartość True w celu użycia biblioteki PIL do wygenerowania obrazu.
    calc_pure_python(draw_output=False, desired_width=1000, max_iterations=300)
