﻿# tweetlistener.py

"""Podklasa klasy bazowej tweepy.StreamListener 
   przechwytująca nadchodzące tweety
   i zapisująca je w bazie MongoDB."""

import tweepy
import json

class TweetListener(tweepy.StreamListener):
    """Obsługa strumienia nadchodzących tweetów"""

    def __init__(self, api, database, limit=10000):
        """Utworzenie zmiennych obiektu kontrolujących liczbę tweetów."""

        self.db = database
        self.tweet_count = 0
        self.TWEET_LIMIT = limit  # domyślnie 10,000
        super().__init__(api)  # wywołanie __init__ z nadklasy 

    def on_connect(self):
        """Metoda wywoływana, gdy połączenie zostaje pomyślnie
           nawiązane. Możliwe staje się wykonywanie zadań wymagających 
           tego połączenia"""
        print('Nawiązano połączenie\n')

    def on_data(self, data):
        """Metoda wywoływana, gdy Twitter dostarcza nowy tweet"""
        self.tweet_count += 1  # kontrola liczby przetworzonych tweetów
        json_data = json.loads(data)  # konwersja surowych danych na dokument JSON
        self.db.tweets.insert_one(json_data)  # dodanie tweetu do kolekcji
        
        # bezpieczne odczytanie atrybutów tweetu
        # gdy któraś z wartości jest nieobecna, nie pojawia się nieobsłużony wyjątek
        # powodujący przerwanie przechwytywania

        try:
            konto = json_data["user"]["name"]
        except:
            konto = '???'
        
        try:
            utworzony = json_data["created_at"]
        except:
            utworzony = '???'

        print(f'            Konto: {konto}') 
        print(f'        Utworzony: {utworzony}')         
        print(f'Otrzymano tweetów: {self.tweet_count}')         

        # gdy osiągnięty zostanie limit liczby tweetów, zwróc FALSE,
        # w przeciwnym razie zwróc TRUE
        return self.tweet_count < self.TWEET_LIMIT
    
    def on_error(self, status):
        print(f'Błąd: {status}')
        return True

##########################################################################
# (C) Copyright 2019 by Deitel & Associates, Inc. and                    #
# Pearson Education, Inc. All Rights Reserved.                           #
#                                                                        #
# DISCLAIMER: The authors and publisher of this book have used their     #
# best efforts in preparing the book. These efforts include the          #
# development, research, and testing of the theories and programs        #
# to determine their effectiveness. The authors and publisher make       #
# no warranty of any kind, expressed or implied, with regard to these    #
# programs or to the documentation contained in these books. The authors #
# and publisher shall not be liable in any event for incidental or       #
# consequential damages in connection with, or arising out of, the       #
# furnishing, performance, or use of these programs.                     #
##########################################################################
