﻿# Rozdział 5. Ciągi: listy i krotki
### 5.2.1. Tworzenie listy
c = [-45, 6, 0, 72, 1543]
c

### 5.2.2. Dostęp do elementów listy
c[0]
c[4]

### 5.2.3. Badanie długości listy
len(c)

### 5.2.4. Indeksowanie elementów listy względem jej końca
c[-1]
c[-5]
c[-len(c)]

### 5.2.5. Indeksy muszą mieć wartości całkowitoliczbowe
a = 1
b = 2
f = 3.0
c[a + b]
c[a + f]

### 5.2.6. Listy są modyfikowalne
c
c[4] = 17
c

### 5.2.7. Niektóre ciągi są niemodyfikowalne
s = 'cześć'
s[0]
s[0] = 'C'

### 5.2.8. Próba dostępu do nieistniejącego elementu
c[5]

# 5.2.9. Elementy listy jako elementy wyrażeń
c
a = 3.4
a + c[1] + c[2] + c[3]
c[c[2]] + c[-c[1]+1]

### 5.2.10. Dołączanie elementów do listy — operator +=
lista = []
for liczba in range(1, 6):
    lista += [liczba]
    print(lista)
--------------------------------
temat = ['P', 'y', 't', 'h', 'o', 'n ']
temat += ' 3.7.4'
print(temat)

### 5.2.11. Konkatenacja list — operator +
lista_1 = [10, 20, 30]
lista_2 = [40, 50]
lista_3 = [60, 70, 80]

lista_wynikowa = lista_1 + lista_2 + lista_3
lista_wynikowa

### 5.2.12. Iterowanie po elementach listy
lista = [10, 20, 30, 40, 50]
n = len(lista)
range_ascending = range(0, n)
range_descending = range(-1, -n-1, -1) 

for i in range_ascending:
    print(lista[i], end=' ')

print('')     

for i in range_descending:
    print(lista[i], end=' ')

### 5.2.13. Porównywanie list
a = [1, 2, 3]
b = [1, 2, 3]
c = [1, 2, 3, 4]

a == b # True: ciągi elementów są identyczne  
a == c # False: ciągi elementów mają różną długość
a < c # True: lista a ma mniej elementów niż c
c >= b # True: elementy 0-2 są identyczne,
       #       ale c ma więcej elementów
