## 12.15. Mapy i geokodowanie
### 12.15.3. Biblioteki Folium   i Leaflet.js 
pip install folium
#### 12.15.5.1. Tworzenie obiektu API
from tweetutilities import get_API
api = get_API()

#### 12.15.5.2. Kolekcje wymagane przez obiekt LocationListener
tweets = []
counts = {'total_tweets': 0, 'locations': 0}

#### 12.15.5.3. Tworzenie obiektu LocationListener
from locationlistener import LocationListener
location_listener = LocationListener(api, counts_dict=counts,
                    tweets_list=tweets, topic='football', limit=50)

#### 12.15.5.4. Rozpoczynanie strumieniowania
import tweepy
stream = tweepy.Stream(auth=api.auth, listener=location_listener)
stream.filter(track=['football'], languages=['en'], is_async=False)

#### 12.15.5.5. Statystyka przechwyconych tweetw
counts['total_tweets'] # liczba wszystkich tweetw
counts['locations'] # liczba tweetw zlokalizowanych
print(f'{counts["locations"] / counts["total_tweets"]:.1%}')

#### 12.15.5.6. Geokodowanie lokalizacji
from tweetutilities import get_geocodes
bad_locations = get_geocodes(tweets)

#### 12.15.5.7. Statystyka nierozpoznanych lokalizacji
bad_locations
print(f'{bad_locations / counts["locations"]:.1%}')

#### 12.15.5.8. Czyszczenie danych
import pandas as pd
df = pd.DataFrame(tweets)
df = df.dropna()

#### 12.15.5.9. Tworzenie mapy
import folium
usmap = folium.Map(location=[39.8283, -98.5795],
                   tiles='Stamen Terrain',
                   zoom_start=5, detect_retina=True)

#### 12.15.5.10. Tworzenie markerw lokalizacji
for t in df.itertuples():
    text = ': '.join([t.screen_name, t.text])
    popup = folium.Popup(text, parse_html=True)
    marker = folium.Marker(
                            (t.latitude, t.longitude),
                            popup=popup
                          )
marker.add_to(usmap)

#### 12.15.5.11. Zapisywanie mapy jako strony WWW
usmap.save('tweet_map.html')

import webbrowser
webbrowser.open('tweet_map.html')