﻿# stocklistener.py

"""Wizualizacja strumienia PubNub"""
from matplotlib import animation
import matplotlib.pyplot as plt
import pandas as pd
import random 
import seaborn as sns
import sys

from pubnub.callbacks import SubscribeCallback
from pubnub.enums import PNStatusCategory
from pubnub.pnconfiguration import PNConfiguration
from pubnub.pubnub import PubNub

companies = ['Apple', 'Bespin Gas', 'Elerium', 'Google', 'Linen Cloth']

# ramka przechowująca aktualne ceny akcji
companies_df = pd.DataFrame(
    {'company': companies, 'price' : [0, 0, 0, 0, 0]})
 
class SensorSubscriberCallback(SubscribeCallback):
    """SensorSubscriberCallback otrzymuje komunikaty od PubNub"""
    def __init__(self, df, limit=1000):
        """Utworzenie zmiennych instancyjnych konmtrolujących l;iczbę tweetów"""
        self.df = df  # ramka przechowująca aktualne notowania
        self.order_count = 0
        self.MAX_ORDERS = limit
        super().__init__()  # wywołanie metody __init__ z nadklasy

    def status(self, pubnub, status):
        if status.category == PNStatusCategory.PNConnectedCategory:
            print('Subskrypcja')
        elif status.category == PNStatusCategory.PNAcknowledgmentCategory:
            print('Koniec subskrypcji')
 
    def message(self, pubnub, message):
        symbol = message.message['symbol']
        bid_price = message.message['bid_price']
        print(symbol, bid_price)
        self.df.at[companies.index(symbol), 'price'] = bid_price
        self.order_count += 1
        
        # jesli osiągnięto limit tweetów MAX_ORDERS, zakończ subskrypcję
        if self.order_count == self.MAX_ORDERS:
            pubnub.unsubscribe_all()
            
def update(frame_number):
    """Konfigurowanie wykresu słupkowego dla bieżącej ramki animacji"""
    plt.cla()  # wyczyść pole wykresu
    axes = sns.barplot(
        data=companies_df, x='company', y='price', palette='cool') 
    axes.set(xlabel='Firma', ylabel='Cena akcji')  
    plt.tight_layout()

if __name__ == '__main__':
    sns.set_style('whitegrid')  # szara siatka na białym tle
    figure = plt.figure('Notowania akcji')  # Obiekt animacji

    # skonfigurowanie i uruchomienie animacji, z funkcją update
    stock_animation = animation.FuncAnimation(
        figure, update, repeat=False, interval=33)
    plt.show(block=False)  # wyświetl w oknie

    # skonfiguruj strumień
    config = PNConfiguration()
    config.subscribe_key = 'sub-c-4377ab04-f100-11e3-bffd-02ee2ddab7fe'
 
    # utwórz klienta Pubnub i zarejestruj odwołanie zwrotne
    pubnub = PubNub(config) 
    pubnub.add_listener(
        SensorSubscriberCallback(df=companies_df, 
            limit=int(sys.argv[1] if len(sys.argv) > 1 else 1000)))

    # zasubskrybuj kanał czujnika i rozpocznij strumieniowanie
    pubnub.subscribe().channels('pubnub-market-orders').execute()
    
    plt.show()  # zachowaj wykres na ekranie, dopóki następny nie będzie gotowy do wyświetlenia

#**************************************************************************
#* (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
#* Pearson Education, Inc. All Rights Reserved.                           *
#*                                                                        *
#* DISCLAIMER: The authors and publisher of this book have used their     *
#* best efforts in preparing the book. These efforts include the          *
#* development, research, and testing of the theories and programs        *
#* to determine their effectiveness. The authors and publisher make       *
#* no warranty of any kind, expressed or implied, with regard to these    *
#* programs or to the documentation contained in these books. The authors *
#* and publisher shall not be liable in any event for incidental or       *
#* consequential damages in connection with, or arising out of, the       *
#* furnishing, performance, or use of these programs.                     *
#**************************************************************************    
    
    

