﻿## 14.6. Analiza przypadku: uczenie nienadzorowane. Część pierwsza — redukcja wymiarowości
### 14.6.1. Wczytanie zbioru danych
from sklearn.datasets import load_digits
digits = load_digits()

### 14.6.2. Tworzenie estymatora redukcyjnego „TSNE”
%matplotlib
from sklearn.manifold import TSNE
tsne = TSNE(n_components=2, random_state=11)

### 14.6.3. Transformacja zbioru „Digits” na postać dwuwymiarową
reduced_data = tsne.fit_transform(digits.data)
reduced_data.shape

### 14.6.4. Wizualizacja zredukowanych danych — monochromatyczna
import matplotlib.pyplot as plt
dots = plt.scatter(reduced_data[:, 0], reduced_data[:, 1],
                   c='black')
### 14.6.5. Wizualizacja zredukowanych danych — kolorystyczne rozróżnienie cyfr

dots = plt.scatter(reduced_data[:, 0], reduced_data[:, 1],
         c=digits.target, cmap=plt.cm.get_cmap('nipy_spectral_r', 10))      

colorbar = plt.colorbar(dots)
