﻿# Rozdział 8. Łańcuchy znaków
## 8.2. Formatowanie łańcuchów
### 8.2.1. Typy prezentacyjne
f'{17.489:.2f}'

#### 8.2.1.1. Liczby całkowite
f'{4397:d}'

#### 8.2.1.2. Znaki tekstu
f'{65:c} {97:c}'

#### 8.2.1.3. Łańcuchy znaków
f'{"Witaj":s} {7}'

#### 8.2.1.4. Typy „float” i „Decimal”
from decimal import Decimal
f'{Decimal("10000000000000000000000000.0"):.3f}'
f'{Decimal("10000000000000000000000000.0"):.3e}'

#### 8.2.2. Specyfikacja szerokości pola i wyrównania
f'[{27:10d}]'
f'[{3.5:10f}]'
f'[{"Cześć!":10}]'

#### 8.2.2.1. Jawna specyfikacja wyrównania prawostronnego lub lewostronnego
f'[{27:<15d}]'
f'[{3.5:<15f}]'
f'[{"Cześć!":>15}]'

#### 8.2.2.2. Wyśrodkowanie wartości w polu
f'[{27:^7d}]'
f'[{3.5:^7.1f}]'
f'[{"Cześć!":^7}]'

#### 8.2.3.1. Formatowanie liczb dodatnich z użyciem znaku „+”
f'[{27:+10d}]'

#### 8.2.3.2.  Dopełnianie zerami
f'[{27:+010d}]'

#### 8.2.3.3. Formatowanie liczb dodatnich ze spacją na pozycji znaku
print(f'{27:d}\n{27: d}\n{-27: d}')

#### 8.2.3.4. Grupowanie cyfr
f'{12345678:,d}'
f'{123456.78:,.2f}'
f'{12345678:,d}'.replace(',', ' ').replace('.', ',')
f'{123456.78:,.2f}'.replace(',', ' ').replace('.', ',')
 
#### 8.2.4. Metoda „format”
'{:.2f}'.format(17.489)

#### 8.2.4.1. Wiele zastępników
'{} {}'.format('Amanda', 'Cyan')

#### 8.2.4.2. Odwołania do formatowanych wyrażeń na podstawie numerów argumentów
'{0} {1} {2} {0} {1} {3}'.format('za', 'siedmioma', 'górami,', 'lasami,')

#### 8.2.4.3. Odwołania do formatowanych wyrażeń na podstawie kluczy argumentów
'{gdzie} {iloma} {c1} {gdzie} {iloma} {c2}'.\
          format(gdzie='za', iloma='siedmioma', c1='górami,', c2='lasami,')

'{gdzie} {iloma} {c2} {gdzie} {iloma} {c1}'.\
          format(gdzie='za', iloma='siedmioma', c1='górami,', c2='lasami,')
