## 16.7. Strumieniowanie Sparka: zliczanie hashtagw przy uyciu pyspark-notebook
### 16.7.1. Uruchamianie kontenera i instalowanie biblioteki Tweepy
pip install tweepy

### 16.7.3. Uruchamianie skryptu w kontenerze
http://localhost:8888/lab
cd work/SparkHashtagSummarizer
ipython starttweetstream.py 10000 football

#### 16.7.3.1. Importowanie moduw
#### 16.7.4.1. Importowanie bibliotek
from pyspark import SparkContext
from pyspark.streaming import StreamingContext
from pyspark.sql import Row, SparkSession
from IPython import display
import matplotlib.pyplot as plt
import seaborn as sns
%matplotlib inline
--------------------------------
https://ipython.readthedocs.io/en/stable/interactive/magics.html

####16.7.4.2. Sesja  obiekt SparkSession
def getSparkSessionInstance(sparkConf):

  """Spark Streaming Programming Guide rekomenduje
     prezentowan tu metod uzyskiwania referencji 
     do istniejcego obiektu SparkSession lub tworzenie
     nowego obiektu tej klasy, gdy jeszcze takowy nie istnieje
     (obiekt ten jest singletonem)."""


   if ("sparkSessionSingletonInstance" not in globals()):
       globals()["sparkSessionSingletonInstance"] = SparkSession \
           .builder \
           .config(conf=sparkConf) \
           .getOrCreate()
   return globals()["sparkSessionSingletonInstance"]

#### 16.7.4.3. Wykres supkowy na podstawie ramki DataFrame
def display_barplot(spark_df, x, y, time, scale=2.0, size=(16, 9)):
    """Wywietlenie zawartoci ramki Spark DataFrame 
       w postaci wykresu supkowego"""
    df = spark_df.toPandas()
    
    # usunicie poprzedniego wykresu w momencie, 
    # gdy nowy wykres stanie si gotowy do wywietlenia
    display.clear_output(wait=True)
    print(f'CZAS: {time}')
    
    # utworzenie i skonfigurowanie obiektu Figure zawierajcego 
    # nowy wykres
    plt.figure(figsize=size)
    sns.set(font_scale=scale)
    barplot = sns.barplot(data=df, x=x, y=y
                          palette=sns.color_palette('cool', 20))

    # obrt etykiet na osi x o kt prosty dla lepszej czytelnoci
    for item in barplot.get_xticklabels():
        item.set_rotation(90)
        
    plt.tight_layout()
    plt.show()
    
#### 16.7.4.4. Czowka 20 hashtagw
def count_tags(time, rdd):
    """Zliczanie hashtagw i wywietlanie 20 najliczniejszych
       w kolejnoci malejcej"""
    try:
        # dostp do obiektuSparkSession
        spark = getSparkSessionInstance(rdd.context.getConf())         

# mapowanie hashtagw postaci acuch-licznik na wiersze Row
rows = rdd.map(
    lambda tag: Row(hashtag=tag[0], total=tag[1]))

# utworzenie ramki DataFrame na podstawie kolekcji wierszy
hashtags_df = spark.createDataFrame(rows)

# utworzenie tymczasowego widoku ramki, do uytku przez Spark SQL
hashtags_df.createOrReplaceTempView('hashtags')

# wybr 20 najliczniejszych hashtagw posortowanych malejco
top20_df = spark.sql(
    """select hashtag, total
       from hashtags
       order by total, hashtag desc
       limit 20""")

    display_barplot(top20_df, x='hashtagi', y='licznik', time=time)
except Exception as e:
    print(f'Bd: {e}')

#### 16.7.4.5. Kontekst  obiekt SparkContext
sc = SparkContext()

#### 16.7.4.6. Strumieniowanie  obiekt StreamingContext
ssc = StreamingContext(sc, 10)
--------------------------------
https://spark.apache.org/docs/latest/streaming-programming-guide.html#performance-tuning

#### 16.7.4.7. Zarzdzanie stanem  punkty kontrolne
ssc.checkpoint('hashtagsummarizer_checkpoint')
--------------------------------
https://spark.apache.org/docs/latest/streaming-programming-guide.html#checkpointing

#### 16.7.4.8. Poczenie ze strumieniem przez gniazdo
stream = ssc.socketTextStream('localhost', 9876)

#### 16.7.4.9. Tokenizacja acucha hashtagw
tokenized = stream.flatMap(lambda line: line.split())

#### 16.7.4.10. Mapowanie hashtagw w krotki hashtag-licznik 
mapped = tokenized.map(lambda hashtag: (hashtag, 1))

#### 16.7.4.11. Sumowanie licznikw
hashtag_counts = tokenized.updateStateByKey(
    lambda counts, prior_total: sum(counts) + (prior_total or 0))

#### 16.7.4.12. Metoda wywoywana dla kadego RDD
hashtag_counts.foreachRDD(count_tags)

#### 16.7.4.13. Rozpoczcie strumieniowania
ssc.start() # rozpoczcie strumieniowania Sparka
