# akwizytornaetacie.py
#-*- coding: 1250 -*-
"""Klasa AkwizytorNaEtacie jako pochodna do Akwizytor."""
from akwizytor import Akwizytor
from decimal import Decimal

class AkwizytorNaEtacie(Akwizytor):
    """Alwizytor, ktry oprcz prowizji od sprzeday
    otrzymuje wynagrodzenie ryczatowe (pensj)"""

    def __init__(self, imie, nazwisko, nr_ubezpieczenia, 
                 sprzedaz, prowizja, pensja):
        """Inicjowaie atrybutw."""
        super().__init__(imie, nazwisko, nr_ubezpieczenia, 
                         sprzedaz, prowizja)
        self.pensja = pensja  # walidacja w ramach waciwoci

    @property
    def pensja(self):
        return self._pensja

    @pensja.setter
    def pensja(self, kwota):
        """Set base salary or raise ValueError if invalid."""
        """Ustalenie wynagrodzenia ryczatowego poprzedzone walidacj."""
        if kwota < Decimal('0.00'):
            raise ValueError('Wynagrodzenie ryczatowe nie moe by ujemne')
        
        self._pensja = kwota

    def zarobek(self):
        """Obliczenie wynagrodzenia."""   
        return super().zarobek() + self.pensja

    def __repr__(self):
        """Reprezentacja tekstowa obiektu."""
        return ('Etatowy ' + super().__repr__() +      
            f'\nryczat: {self.pensja:.2f}')



##########################################################################
# (C) Copyright 2019 by Deitel & Associates, Inc. and                    #
# Pearson Education, Inc. All Rights Reserved.                           #
#                                                                        #
# DISCLAIMER: The authors and publisher of this book have used their     #
# best efforts in preparing the book. These efforts include the          #
# development, research, and testing of the theories and programs        #
# to determine their effectiveness. The authors and publisher make       #
# no warranty of any kind, expressed or implied, with regard to these    #
# programs or to the documentation contained in these books. The authors #
# and publisher shall not be liable in any event for incidental or       #
# consequential damages in connection with, or arising out of, the       #
# furnishing, performance, or use of these programs.                     #
##########################################################################
