﻿# Rozdział 15. Głębokie uczenie
## 15.3. Alternatywne środowiska Anacondy
### 15.3.2. Tworzenie środowiska
conda create -n tf_env tensorflow anaconda ipython jupyterlab scikit-learn matplotlib seaborn h5py pydot graphviz

### 15.3.3. Aktywowanie alternatywnego środowiska
conda activate tf_env

### 15.3.4. Dezaktywacja alternatywnego środowiska
conda deactivate

### 15.6.1. Powtarzalność głębokiego uczenia w bibliotece „Keras” 
https://keras.io/getting-started/faq/

### 15.6.4. Wczytanie zbioru „MNIST” 
from tensorflow.keras.datasets import mnist 
(X_train, y_train), (X_test, y_test) = mnist.load_data()

### 15.6.5. Eksploracja danych
X_train.shape
y_train.shape
X_test.shape
y_test.shape

#### 15.6.5.1. Wizualizacja cyfr
%matplotlib inline
import matplotlib.pyplot as plt
import seaborn as sns
sns.set(font_scale=2)
--------------------------------
https://ipython.readthedocs.io/en/stable/interactive/magics.html
--------------------------------
import numpy as np
index = np.random.choice(np.arange(len(X_train)), 24, replace=False)
figure, axes = plt.subplots(nrows=4, ncols=6, figsize=(16, 9))
for item in zip(axes.ravel(), X_train[index], y_train[index]):
    axes, image, target = item
    axes.imshow(image, cmap=plt.cm.gray_r)
    axes.set_xticks([]) # usunięcie znaczników z osi x
    axes.set_yticks([]) # usunięcie znaczników z osi y
    axes.set_title(target)
plt.tight_layout()

 
#### 15.6.6.1. Zmiana struktury danych
X_train = X_train.reshape((60000, 28, 28, 1))
X_train.shape
X_test = X_test.reshape((10000, 28, 28, 1))
X_test.shape

#### 15.6.6.2. Normalizacja danych
X_train = X_train.astype('float32') / 255
X_test = X_test.astype('float32') / 255

#### 15.6.6.3. Kodowanie z „gorącą jedynką”: konwersja liczb całkowitych na dane kategoryczne
from tensorflow.keras.utils import to_categorical
y_train = to_categorical(y_train)
y_train.shape
y_train[0]
y_test = to_categorical(y_test)
y_test.shape

### 15.6.7. Budowanie sieci neuronowej
from tensorflow.keras.models import Sequential
cnn = Sequential()

#### 15.6.7.1. Dodawanie warstw do sieci
from tensorflow.keras.layers import Conv2D, Dense, Flatten,MaxPooling2D

##### 15.6.7.1.2. Dodawanie warstwy konwolucji
cnn.add(Conv2D(filters=64, kernel_size=(3, 3), activation='relu', 
               input_shape=(28, 28, 1)))

##### 15.6.7.1.5. Dodawanie warstwy łączącej
cnn.add(MaxPooling2D(pool_size=(2, 2)))
##### 15.6.7.1.6. Dodawanie kolejnych warstw: konwolucyjnej i łączącej
cnn.add(Conv2D(filters=128, kernel_size=(3, 3), activation='relu'))
cnn.add(MaxPooling2D(pool_size=(2, 2)))

##### 15.6.7.1.7. Spłaszczanie wyników
cnn.add(Flatten())

##### 15.6.7.1.8. Dodawanie warstwy gęstej w celu redukcji liczby cech
cnn.add(Dense(units=128, activation='relu'))

##### 15.6.7.1.9. Dodawanie kolejnej warstwy gęstej produkującej wynik klasyfikacji
cnn.add(Dense(units=10, activation='softmax'))

##### 15.6.7.1.10. Podsumowanie modelu
cnn.summary()

##### 15.6.7.1.11. Wizualizacja struktury modelu
from tensorflow.keras.utils import plot_model
from IPython.display import Image
plot_model(cnn, to_file='convnet.png', show_shapes=True,
           show_layer_names=True)

Image(filename='convnet.png')

##### 15.6.7.1.12. Kompilowanie modelu
cnn.compile(optimizer='adam',
            loss='categorical_crossentropy',
            metrics=['accuracy'])

### 15.6.8. Trenowanie i ewaluacja modelu
cnn.fit(X_train, y_train, epochs=5, batch_size=64,
        validation_split=0.1)

#### 15.6.8.1. Ewaluacja
loss, accuracy = cnn.evaluate(X_test, y_test)
loss
accuracy

#### 15.6.8.2. Prognozowanie
przypuszczenia = cnn.predict(X_test)
y_test[0]
for indeks, przypuszczenie in enumerate(przypuszczenia[0]):
    print(f'{indeks}: { przypuszczenie:.10%}')

#### 15.6.8.3. Wyszukiwanie chybionych prognoz
obrazy = X_test.reshape((10000, 28, 28))
chybione_prognozy = []
      
for i, (p, e) in enumerate(zip(przypuszczenia, y_test)):
    prognozowany, spodziewany = np.argmax(p), np.argmax(e)

    if prognozowany != spodziewany:
        chybione_prognozy.append(
            (i, obrazy[i], prognozowany, spodziewany))
            
len(chybione_prognozy)

#### 15.6.8.4. Wizualizacja chybionych prognoz
figure, axes = plt.subplots(nrows=4, ncols=6, figsize=(16, 12))

for axes, element in zip(axes.ravel(), chybione_prognozy):
    indeks, obraz, prognozowany, spodziewany = element
    axes.imshow(obraz, cmap=plt.cm.gray_r)
    axes.set_xticks([]) # usuń znaczniki z osi x
    axes.set_yticks([]) # usuń znaczniki z osi y
    axes.set_title(
        f'indeks: {indeks}\np: {prognozowany}; s: {spodziewany}')

plt.tight_layout()

#### 15.6.8.5. Szczegóły niektórych chybionych prognoz
def wypisz_przypuszczenia(prognoza):
    for indeks, przypuszczenie in enumerate(prognoza):
        print(f'{indeks}: {przypuszczenie:.10%}')

wypisz_przypuszczenia(przypuszczenia[495])

wypisz_przypuszczenia(przypuszczenia[583])

wypisz_przypuszczenia(przypuszczenia[625])

### 15.6.9. Zapisywanie i ładowanie modelu
cnn.save('mnist_cnn.h5')

from tensorflow.keras.models import load_model
cnn = load_model('mnist_cnn.h5')
--------------------------------
https://keras.io/getting-started/faq/#how-can-i-save-a-keras-model

## 15.7. TensorBoard — wizualizacja trenowania sieci
### 15.7.1. Uruchamianie serwera
conda activate tf_env
mkdir logs
tensorboard --logdir=logs
http://localhost:6006

### 15.7.4. Konfigurowanie plików dziennika
from tensorflow.keras.callbacks import TensorBoard 
import time
tensorboard_callback = TensorBoard(log_dir=f'./logs/mnist{time.time()}',
    histogram_freq=1, write_graph=True)

#### 15.7.4.1. Modyfikacja wywołania metody „fit” 
cnn.fit(X_train, y_train, epochs=10, batch_size=64,
        validation_split=0.1, callbacks=[tensorboard_callback])

## 15.8. ConvNetJS: wizualizacja trenowania w oknie przeglądarki WWW
https://github.com/karpathy/convnetjs

### 15.8.2. Sekcja „Instantiate a Network and Trainer”
https://cs.stanford.edu/people/karpathy/convnetjs/docs.html.

## 15.9. Rekurencyjne sieci neuronowe i ciągi danych: analiza sentymentu w zbiorze „IMDb” 
### 15.9.1. Wczytywanie zbioru „IMDb” 
from tensorflow.keras.datasets import imdb
number_of_words = 10000
(X_train, y_train), (X_test, y_test) = imdb.load_data(
             num_words=number_of_words)

### 15.9.2. Eksploracja danych
X_train.shape
y_train.shape
X_test.shape
y_test.shape
%pprint
X_train[123]

#### 15.9.2.2. Dekodowanie recenzji
word_to_index = imdb.get_word_index()
word_to_index['great']
index_to_word = \
    {index: word for (word, index) in word_to_index.items()}

[index_to_word[i] for i in range(1, 51)]

' '.join([index_to_word.get(i - 3, '?') for i in X_train[123]])

y_train[123]

### 15.9.3. Preparacja danych
words_per_review = 200    # maksymalna liczba słów w recenzji
from tensorflow.keras.preprocessing.sequence import pad_sequences
X_train = pad_sequences(X_train, maxlen=words_per_review)
X_train.shape
X_test = pad_sequences(X_test, maxlen=words_per_review)
X_test.shape

#### 15.9.3.1. Wydzielenie próbek walidacyjnych
from sklearn.model_selection import train_test_split
X_test, X_val, y_test, y_val = train_test_split(
    X_test, y_test, random_state=11, test_size=0.20)

X_test.shape

X_val.shape

### 15.9.4. Budowanie sieci neuronowej
from tensorflow.keras.models import Sequential
rnn = Sequential()

from tensorflow.keras.layers import Dense, LSTM
from tensorflow.keras.layers.embeddings import Embedding

#### 15.9.4.1. Dodawanie warstwy osadzania
rnn.add(Embedding(input_dim=number_of_words, output_dim=128,
                        input_length=words_per_review))

#### 15.9.4.2. Dodawanie warstwy LSTM
rnn.add(LSTM(units=128, dropout=0.2, recurrent_dropout=0.2))

#### 15.9.4.3. Dodawanie końcowej warstwy gęstej
rnn.add(Dense(units=1, activation='sigmoid'))

#### 15.9.4.4. Kompilowanie modelu i wypisywanie podsumowania
rnn.compile(optimizer='adam',
            loss='binary_crossentropy',
            metrics=['accuracy'])

rnn.summary()

rnn.fit(X_train, y_train, epochs=10, batch_size=32,
        validation_data=(X_test, y_test))

results = rnn.evaluate(X_test, y_test)
results

## 15.10. Dostrajanie modeli głębokiego uczenia
## 15.11. Modele wstępnie wytrenowane 
### 15.11.1. Modele biblioteki „Keras” wytrenowane na zbiorze „ImageNet” 
### 15.11.2. Wieloużywalność wytrenowanych modeli
https://keras.io/applications/
