# simulator.py
#-*- coding: 1250 -*-

# (C) Copyright 2019 by Deitel & Associates, Inc. and                    #
# Pearson Education, Inc. All Rights Reserved.                           #
# Revised by A.Grayski, (C) Copyright 2020 by Helion Publishing


"""Symulator termostatu przyczonego do internetu,
   publikujcego komunikaty JSON dla usugi dweet.io"""
   

import dweepy
import sys
import time
import random

MIN_CELSIUS_TEMP = -25  
MAX_CELSIUS_TEMP = 45 
MAX_TEMP_CHANGE = 2

MIN_SAFE_TEMP = 3
MAX_SAFE_TEMP = 35

# Gdy True, identyfikator dweetw generowany przez usug
# Opcja GEN_RANDOM_THING_NAME jest bez znaczenia
AUTO_GEN_THING_NAME = True

# Gdy True, identyfikator dweetw jest generowany 
# z udziaem UUID. Gdy False, ustalany jest domylny
# idenyfikator
GEN_RANDOM_THING_NAME = True

# Gdy True, automatycznie uruchamiany jest podgld dweetw
AUTO_BROWSE_WWW = True

# argumenty wywoania:
#   1. Liczba komunikatw
#   2. Interwa czasowy midzy kolejnymi komunikatami 
NUMBER_OF_MESSAGES = int(sys.argv[1]) 
MESSAGE_DELAY = int(sys.argv[2])

if AUTO_GEN_THING_NAME:
    dweeter = ''
elif GEN_RANDOM_THING_NAME:
    import uuid
    dweeter = 'PFPr16-iot-therm-' + str(uuid.uuid4())
    print('Unikalny identyfikator:\n' + dweeter)
    print()
else:
    dweeter = 'temperature-simulator-deitel-python' # unikalna nazwa publikatora

thermostat = {'Location': 'Boston, MA, USA',
              'Temperature': 20, 
              'LowTempWarning': False,
              'HighTempWarning': False}

print('Start symulatora termostatu')

for message in range(NUMBER_OF_MESSAGES):
    # generowanie losowej wartoci temperatury, z zachowaniem
    # dopuszczalnej rnicy wzgldem poprzedniej wartoci
    # (bo w rzeczywistoci temperatura nie zmienia si zbyt gwatownie)
    thermostat['Temperature'] += random.randrange(
        -MAX_TEMP_CHANGE, MAX_TEMP_CHANGE + 1)
    
    # adjustacja wartoci temperatury do dozwolonych granic
    if thermostat['Temperature'] < MIN_CELSIUS_TEMP:
        thermostat['Temperature'] = MIN_CELSIUS_TEMP
    
    if thermostat['Temperature'] > MAX_CELSIUS_TEMP:
        thermostat['Temperature'] = MAX_CELSIUS_TEMP
    
    # kontrola temperatury wzgldem dolnej granicy bezpieczestwa
    if thermostat['Temperature'] < MIN_SAFE_TEMP:
        thermostat['LowTempWarning'] = True
    else:
        thermostat['LowTempWarning'] = False

    # kontrola temperatury wzgldem grnej granicy bezpieczestwa
    if thermostat['Temperature'] > MAX_SAFE_TEMP:
        thermostat['HighTempWarning'] = True
    else:
        thermostat['HighTempWarning'] = False
        
    # wysanie dweetu do usugi dweet.io poprzez bibliotek Dweepy
    print(f'Wysano komunikat nr: {message + 1}\r', end='')
    if dweeter == '':
        response = dweepy.dweet(thermostat)
        dweeter = response['thing']
        print('Automatyczny identyfikator:', dweeter)
    else:    
        dweepy.dweet_for(dweeter, thermostat)

    time.sleep(MESSAGE_DELAY)

print('Zatrzymanie symulatora termostatu')

if AUTO_BROWSE_WWW:
    print('Otwieranie przegldarki:')
    print()
    import webbrowser
    webbrowser.open('https://dweet.io/get/dweets/for/' + dweeter)
