## 10.6. Analiza przypadku: symulacja tasowania i rozdawania kart
#### 10.6.1.1. Tworzenie i tasowanie kart
from talia import TaliaKart
talia_kart = TaliaKart()
print(talia_kart)
talia_kart.tasuj()
print(talia_kart)

#### 10.6.1.2. Rozdawanie kart
talia_kart.kolejna_karta_z_talii()

#### 10.6.1.3. Inne cechy klasy Karta
karta = talia_kart.kolejna_karta_z_talii()
str(karta)
karta.nazwa_pliku_obrazu

### 10.6.7. Wywietlanie obrazw kart
from talia import TaliaKart
talia_kart = TaliaKart()

#### 10.6.7.1. Wczanie obsugi Matplotliba
%matplotlib

#### 10.6.7.2. cieka bazowa pliku graficznego
from pathlib import Path
path = Path('.').joinpath('card_images')

#### 10.6.7.3. Importowanie moduw Matplotliba
import matplotlib.pyplot as plt
import matplotlib.image as mpimg

#### 10.6.7.4. Tworzenie obiektw okna wykresu i osi
figure, axes_list = plt.subplots(nrows=4, ncols=13)

#### 10.6.7.5. Konfigurowanie obiektw osi i wywietlanie  obrazw
for axes in axes_list.ravel():
    axes.get_xaxis().set_visible(False)
    axes.get_yaxis().set_visible(False)
    image_name = talia_kart.kolejna_karta_z_talii().nazwa_pliku_obrazu
    img = mpimg.imread(str(path.joinpath(image_name).resolve()))
    axes.imshow(img)

#### 10.6.7.6. Maksymalizacja obrazw
figure.tight_layout()

#### 10.6.7.7. Tasowanie i ponowne rozdanie
talia_kart.tasuj()

for axes in axes_list.ravel():
    axes.get_xaxis().set_visible(False)
    axes.get_yaxis().set_visible(False)
    image_name = talia_kart.kolejna_karta_z_talii().nazwa_pliku_obrazu
    img = mpimg.imread(str(path.joinpath(image_name).resolve()))
    axes.imshow(img)
