## 9.9. Klauzula finally 
### 9.9.1. Konstrukcja try  finally 
try:
    print('Suita try, w czasie wykonania ktrej nie wystpuj wyjtki')
except:
    print('Ta instrukcja nie zostanie wykonana')
else:
    print(
          'Suita else bdzie zawsze wykonywana, ' + 
          'bo nigdy nie wystpi wyjtek'
         ) 
finally:
    print('Suita finally zawsze jest wykonywana')

try:
    print('Nastpna instrukcja spowoduje wyjtek')
    int('cze')
    print('Do tej instrukcji sterowanie ju nie dotrze')
except ValueError:
    print('Wystpi wyjtek ValueError')
else:
    print('Ta instrukcja nie zostanie wykonana, bo wystpi wyjtek')
finally:
    print('Suita finally zawsze jest wykonywana')

### 9.9.2. Instrukcja with w poczeniu z try  except
open('nie_ma_mnie.txt')
--------------------------------
import os
in_file = 'oceny_roczne.txt'
out_file = 'oceny_roczne.csv'

try:
    with open(out_file, 'w') as transfer, open(in_file, 'r') as oceny:
        print(f'{"ID":<5}{"Nazwisko":<21}{"Ocena":>6}')

        for rekord in oceny:
            id_studenta, nazwisko, ocena = rekord.split()
            print(f'{id_studenta:<5}{nazwisko:<21}{ocena:>6}')
            linia = ','.join([id_studenta, nazwisko, ocena])
            transfer.write(linia + '\n')
            
except FileNotFoundError:
    print(f'Plik "{in_file}" nie istnieje')

    if os.path.isfile(out_file):
        os.remove(out_file)
        if not os.path.isfile(out_file):
            print(f'Usunito plik "{out_file}"')
