﻿## 9.5. Serializacja obiektów w formacie JSON
### 9.5.1. Notacja JSON
{"nr_konta": 100, "nazwa": "Jones", "stan_konta": 24.98}
[100, 200, 300]

### 9.5.2. Moduł „json” biblioteki standardowej
accounts_dict = {'accounts': [
                  {'nr_konta': 100, 'nazwa': 'Jones', 'stan_konta': 24.98},
                  {'nr_konta': 200, 'nazwa': 'Doe', 'stan_konta': 345.67}]
                }

#### 9.5.2.1. Serializowanie obiektu
import json

with open('accounts.json', 'w') as accounts:
    json.dump(accounts_dict, accounts)

#### 9.5.2.2. Odtwarzanie (deserializacja) obiektu
with open('accounts.json', 'r') as accounts:
    accounts_json = json.load(accounts)

accounts_json

accounts_json['accounts']

accounts_json['accounts'][0]

accounts_json['accounts'][1]

#### 9.5.2.3. Formatowany wydruk
with open('accounts.json', 'r') as accounts:
    print(json.dumps(json.load(accounts), indent=4))
   
