﻿# dividebyzero.py

"""Prosty przykład obsługi wyjątków."""

while True:
    # konwersja wprowadzanych wartości na liczby całkowite
    # i obliczenie ich ilorazu
    #
    # żądanie podania liczb ponawiane jest aż do wprowadzenia
    # poprawnych liczb całkowitych
    try:
        licznik = int(input('Podaj licznik: '))
        mianownik = int(input('Podaj mianownik: '))
        iloraz = licznik / mianownik
    except ValueError:  # próba konwersji ciągu nienumerycznego na liczbę
        print('Musisz wprowadzić dwie liczby całkowite\n')
    except ZeroDivisionError:  # zerowy mianownik
        print('Próba dzielenia przez zero\n')
    else:  # kontynuacja wykonania tylko wtedy, gdy nie wystąpił wyjątek
        print(f'{licznik:.3f} / {mianownik:.3f} = {iloraz:.3f}')
        break # przerwanie pętli


##########################################################################
# (C) Copyright 2019 by Deitel & Associates, Inc. and                    #
# Pearson Education, Inc. All Rights Reserved.                           #
#                                                                        #
# DISCLAIMER: The authors and publisher of this book have used their     #
# best efforts in preparing the book. These efforts include the          #
# development, research, and testing of the theories and programs        #
# to determine their effectiveness. The authors and publisher make       #
# no warranty of any kind, expressed or implied, with regard to these    #
# programs or to the documentation contained in these books. The authors #
# and publisher shall not be liable in any event for incidental or       #
# consequential damages in connection with, or arising out of, the       #
# furnishing, performance, or use of these programs.                     #
##########################################################################
